<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Processor\Quote;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteAjustmentEnum;
use Sylius\Component\Core\Model\AdjustmentInterface;
use Sylius\Component\Order\Factory\AdjustmentFactoryInterface;

class QuoteAdjustmentsProcessor implements QuoteProcessorInterface
{
    private AdjustmentFactoryInterface $adjustmentFactory;

    public function __construct(
        AdjustmentFactoryInterface $adjustmentFactory,
    ) {
        $this->adjustmentFactory = $adjustmentFactory;
    }

    public function process(OrderInterface $quote): void
    {
        $quoteInformation = $quote->getQuoteInformation();

        /** @var OrderItemInterface $item */
        foreach ($quote->getItems() as $item) {
            $quoteItemInformation = $item->getQuoteItemInformation();

            if ($quoteItemInformation->getUnitPrice() !== null) {
                if ($quoteItemInformation->getUnitPrice() !== $item->getUnitPrice()) {
                    $adjustment = $this->adjustmentFactory->createWithData(
                        QuoteAjustmentEnum::ITEM_UNIT_PRICE_ADJUSTMENT,
                        'quote_item_adjustment',
                        $quoteItemInformation->getUnitPrice() -
                        $item->getUnitPrice(),
                    );
                    $item->addAdjustment($adjustment);
                }
            }
        }

        if ($quoteInformation->getTotal() !== null) {
            if ($quoteInformation->getTotal() !== $quote->getQuoteInformation()->getItemsTotal()) {
                $adjustment = $this->adjustmentFactory->createWithData(
                    AdjustmentInterface::ORDER_PROMOTION_ADJUSTMENT,
                    'quote_adjustment',
                    $quoteInformation->getTotal() - $quote->getQuoteInformation()->getItemsTotal(),
                );
                $quote->addAdjustment($adjustment);
            }
        }
    }
}
