<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Processor\Order;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\OrderStateEnum;
use Sylius\Component\Order\Model\OrderInterface as BaseOrderInterface;
use Sylius\Component\Order\Processor\OrderProcessorInterface;
use Webmozart\Assert\Assert;

final class ShippingChargesProcessor implements OrderProcessorInterface
{
    public function __construct(private OrderProcessorInterface $decoratedProcessor)
    {
    }

    public function process(BaseOrderInterface $order): void
    {
        Assert::isInstanceOf($order, OrderInterface::class);

        if (OrderStateEnum::STATE_NONE !== $order->getQuoteState()) {
            return;
        }

        $this->decoratedProcessor->process($order);
    }
}
