<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Processor\Order;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Sylius\Component\Core\Model\AdjustmentInterface;
use Sylius\Component\Order\Factory\AdjustmentFactoryInterface;
use Sylius\Component\Order\Model\OrderInterface as BaseOrderInterface;
use Sylius\Component\Order\Processor\OrderProcessorInterface;
use Webmozart\Assert\Assert;

class QuoteAdjustmentsProcessor implements OrderProcessorInterface
{
    private AdjustmentFactoryInterface $adjustmentFactory;

    public function __construct(
        AdjustmentFactoryInterface $adjustmentFactory,
    ) {
        $this->adjustmentFactory = $adjustmentFactory;
    }

    public function process(BaseOrderInterface $order): void
    {
        Assert::isInstanceOf($order, OrderInterface::class);

        /** @var OrderInterface|null $quote */
        $quote = $order->getQuote();

        if (null === $quote) {
            return;
        }

        $quoteInformation = $quote->getQuoteInformation();

        if ($quoteInformation->getTotal() !== null) {
            if ($quoteInformation->getTotal() !== $order->getItemsTotal()) {
                $adjustment = $this->adjustmentFactory->createWithData(
                    AdjustmentInterface::ORDER_PROMOTION_ADJUSTMENT,
                    'quote_adjustment',
                    $quoteInformation->getTotal() - $order->getItemsTotal(),
                );
                $order->addAdjustment($adjustment);
            }
        }
    }
}
