<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\NumberAssigner;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\NumberGenerator\QuoteNumberGeneratorInterface;

class QuoteNumberAssigner implements QuoteNumberAssignerInterface
{
    private readonly QuoteNumberGeneratorInterface $quoteNumberGenerator;

    public function __construct(QuoteNumberGeneratorInterface $quoteNumberGenerator)
    {
        $this->quoteNumberGenerator = $quoteNumberGenerator;
    }

    public function assignNumber(OrderInterface $quote): void
    {
        if (null !== $quote->getNumber()) {
            return;
        }

        $quote->getQuoteInformation()->setNumber($this->quoteNumberGenerator->generate($quote));
    }
}
