<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Mailer;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Sylius\Component\Mailer\Sender\SenderInterface;

class QuoteEmailManager implements QuoteEmailManagerInterface
{
    private readonly SenderInterface $sender;

    public function __construct(SenderInterface $sender)
    {
        $this->sender = $sender;
    }

    public function sendConfirmationEmail(OrderInterface $quote): void
    {
        $this->sender->send(
            EmailsEnum::QUOTE_CONFIRMATION,
            [$quote->getCustomer()->getEmail()],
            [
                'quote' => $quote,
                'channel' => $quote->getChannel(),
                'localeCode' => $quote->getLocaleCode(),
            ],
        );
    }

    public function sendAcceptEmail(OrderInterface $quote): void
    {
        $this->sender->send(
            EmailsEnum::QUOTE_ACCEPT,
            [$quote->getCustomer()->getEmail()],
            [
                'quote' => $quote,
                'channel' => $quote->getChannel(),
                'localeCode' => $quote->getLocaleCode(),
            ],
        );
    }

    public function sendDenyEmail(OrderInterface $quote): void
    {
        $this->sender->send(
            EmailsEnum::QUOTE_DENY,
            [$quote->getCustomer()->getEmail()],
            [
                'quote' => $quote,
                'channel' => $quote->getChannel(),
                'localeCode' => $quote->getLocaleCode(),
            ],
        );
    }
}
