<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Grid\Filter;

use Sylius\Component\Grid\Data\DataSourceInterface;
use Sylius\Component\Grid\Filtering\FilterInterface;

class SingleDateFilter implements FilterInterface
{
    public function apply(DataSourceInterface $dataSource, string $name, $data, array $options): void
    {
        $field = (string) $this->getOption($options, 'field', $name);

        if (is_string($data['date']) && '' !== $data['date']) {
            $dataSource->restrict($dataSource->getExpressionBuilder()->like($field, sprintf('%s%%', $data['date'])));
        }
    }

    private function getOption(array $options, string $name, $default)
    {
        return $options[$name] ?? $default;
    }
}
