<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Form\Type\Process;

use Sylius\Bundle\ProductBundle\Form\Type\ProductVariantChoiceType;
use Sylius\Bundle\ProductBundle\Form\Type\ProductVariantMatchType;
use Sylius\Component\Core\Model\ProductInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataMapperInterface;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class QuoteItemType extends AbstractType
{
    private readonly string $dataClass;

    private readonly DataMapperInterface $dataMapper;

    public function __construct(string $dataClass, DataMapperInterface $dataMapper)
    {
        $this->dataClass = $dataClass;
        $this->dataMapper = $dataMapper;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('quantity', IntegerType::class, [
                'attr' => ['min' => 1],
                'label' => 'sylius.ui.quantity',
            ])
            ->setDataMapper($this->dataMapper)
        ;

        if (isset($options['product']) && $options['product']->hasVariants() && !$options['product']->isSimple()) {
            $type =
                ProductInterface::VARIANT_SELECTION_CHOICE === $options['product']->getVariantSelectionMethod()
                    ? ProductVariantChoiceType::class
                    : ProductVariantMatchType::class;

            $builder->add('variant', $type, [
                'product' => $options['product'],
            ]);
        }
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefined(['product'])
            ->setAllowedTypes('product', ProductInterface::class)
            ->setDefaults(['data_class' => $this->dataClass])
        ;
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_sylius_quote_quote_item';
    }
}
