<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Sales;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Specification\Order\IsQuoteSpecificationInterface;
use Sylius\Bundle\ResourceBundle\Event\ResourceControllerEvent;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Storage\CartStorageInterface;

class CartClearPreDeleteListener
{
    public function __construct(
        private readonly IsQuoteSpecificationInterface $isQuoteSpecification,
        private readonly CartStorageInterface $cartStorage,
        private readonly ChannelContextInterface $channelContext,
    ) {
    }

    public function __invoke(ResourceControllerEvent $event): void
    {
        /** @var OrderInterface $order */
        $order = $event->getSubject();

        if ($this->isQuoteSpecification->isSatisfiedBy($order)) {
            /** @var ChannelInterface $channel */
            $channel = $this->channelContext->getChannel();

            if ($this->cartStorage->hasForChannel($channel)) {
                $this->cartStorage->removeForChannel($channel);
            }

            $event->stop('dedi_sylius_quote.ui.cart_cleared', ResourceControllerEvent::TYPE_SUCCESS);
        }
    }
}
