<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Entity;

class QuoteItemInformation implements QuoteItemInformationInterface
{
    protected ?int $id = null;

    protected OrderItemInterface $orderItem;

    protected ?int $unitPrice = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getOrderItem(): OrderItemInterface
    {
        return $this->orderItem;
    }

    public function setOrderItem(OrderItemInterface $orderItem): self
    {
        $this->orderItem = $orderItem;

        return $this;
    }

    public function getUnitPrice(): ?int
    {
        return $this->unitPrice;
    }

    public function setUnitPrice(?int $unitPrice): self
    {
        $this->unitPrice = $unitPrice;

        return $this;
    }

    public function getTotal(): ?int
    {
        return $this->unitPrice * $this->orderItem->getQuantity();
    }
}
