<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Entity;

use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

class QuoteInformation implements QuoteInformationInterface
{
    protected ?int $id = null;

    protected OrderInterface $order;

    protected ?string $number = null;

    protected ?string $customerComment = null;

    protected ?string $informationComment = null;

    /** @var Collection<InternalCommentInterface> */
    protected Collection $internalComments;

    protected ?DateTimeInterface $createdAt = null;

    protected ?DateTimeInterface $updatedAt = null;

    protected ?DateTimeInterface $expirationDate = null;

    protected ?int $total = null;

    public function __construct()
    {
        $this->internalComments = new ArrayCollection();
        $this->createdAt = new \DateTime();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNumber(): ?string
    {
        return $this->number;
    }

    public function setNumber(?string $number): self
    {
        $this->number = $number;

        return $this;
    }

    public function getCustomerComment(): ?string
    {
        return $this->customerComment;
    }

    public function setCustomerComment(?string $customerComment): self
    {
        $this->customerComment = $customerComment;

        return $this;
    }

    public function getInformationComment(): ?string
    {
        return $this->informationComment;
    }

    public function setInformationComment(?string $informationComment): self
    {
        $this->informationComment = $informationComment;

        return $this;
    }

    public function getInternalComments(): Collection
    {
        return $this->internalComments;
    }

    public function setInternalComments(Collection $internalComments): self
    {
        $this->internalComments = $internalComments;

        return $this;
    }

    public function hasInternalComment(InternalCommentInterface $internalComment): bool
    {
        return $this->internalComments->contains($internalComment);
    }

    public function addInternalComment(InternalCommentInterface $internalComment): self
    {
        if (!$this->hasInternalComment($internalComment)) {
            $this->internalComments->add($internalComment);
            $internalComment->setQuoteInformation($this);
        }

        return $this;
    }

    public function removeInternalComment(InternalCommentInterface $internalComment): self
    {
        if ($this->hasInternalComment($internalComment)) {
            $this->internalComments->removeElement($internalComment);
            $internalComment->setQuoteInformation(null);
        }

        return $this;
    }

    public function getExpirationDate(): ?DateTimeInterface
    {
        return $this->expirationDate;
    }

    public function setExpirationDate(?DateTimeInterface $expirationDate): self
    {
        $this->expirationDate = $expirationDate;

        return $this;
    }

    public function getCreatedAt(): ?DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?DateTimeInterface $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?DateTimeInterface
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(?DateTimeInterface $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getOrder(): OrderInterface
    {
        return $this->order;
    }

    public function setOrder(OrderInterface $order): self
    {
        $this->order = $order;

        return $this;
    }

    public function getTotal(): ?int
    {
        return $this->total;
    }

    public function setTotal(?int $total): self
    {
        $this->total = $total;

        return $this;
    }

    public function getItemsTotal(): ?int
    {
        $total = 0;
        /** @var OrderItemInterface $item */
        foreach ($this->order->getItems() as $item) {
            $total += $item->getQuoteItemInformation()->getTotal();
        }

        return $total;
    }
}
