<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\DependencyInjection;

use Dedi\SyliusQuotePlugin\Processor\Quote\QuoteProcessorInterface;
use Sylius\Bundle\ResourceBundle\DependencyInjection\Extension\AbstractResourceExtension;
use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

final class DediSyliusQuoteExtension extends AbstractResourceExtension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration($this->getConfiguration([], $container), $configs);
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $this->registerResources('dedi_sylius_quote', $config['driver'], $config['resources'], $container);
        $loader->load('services.xml');

        $settingsDefinition = $container->getDefinition('dedi_sylius_quote.settings');
        $settingsDefinition->setArgument('$enabled', $config['enabled']);
        $settingsDefinition->setArgument('$anonymousQuoteAllowed', $config['anonymous_quote_allowed']);
        $settingsDefinition->setArgument('$cartEditAllowed', $config['cart_edit_allowed']);

        $container
            ->registerForAutoconfiguration(QuoteProcessorInterface::class)
            ->addTag(RegisterProcessorsPass::PROCESSOR_SERVICE_TAG)
        ;
    }

    public function getConfiguration(array $config, ContainerBuilder $container): ConfigurationInterface
    {
        return new Configuration();
    }
}
