<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Converter;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Sylius\Component\Core\Factory\CartItemFactoryInterface;
use Sylius\Component\Order\Modifier\OrderItemQuantityModifierInterface;
use Sylius\Component\Order\Processor\OrderProcessorInterface;

class QuoteToCartConverter implements QuoteToCartConverterInterface
{
    private readonly CartItemFactoryInterface $cartItemFactory;

    private readonly OrderItemHydratorInterface $orderItemHydrator;

    private readonly OrderItemQuantityModifierInterface $orderItemQuantityModifier;

    private readonly OrderProcessorInterface $orderProcessor;

    public function __construct(
        CartItemFactoryInterface $cartItemFactory,
        OrderItemHydratorInterface $orderItemHydrator,
        OrderItemQuantityModifierInterface $orderItemQuantityModifier,
        OrderProcessorInterface $orderProcessor,
    ) {
        $this->cartItemFactory = $cartItemFactory;
        $this->orderItemQuantityModifier = $orderItemQuantityModifier;
        $this->orderProcessor = $orderProcessor;
        $this->orderItemHydrator = $orderItemHydrator;
    }

    public function convert(OrderInterface $quote, OrderInterface $cart): void
    {
        $cart->setQuote($quote);

        /** @var OrderItemInterface $quoteItem */
        foreach ($quote->getItems() as $quoteItem) {
            /** @var OrderItemInterface $cartItem */
            $cartItem = $this->cartItemFactory->createForCart($cart);

            $this->orderItemHydrator->hydrateFromQuoteItem($cartItem, $quoteItem);

            $this->orderItemQuantityModifier->modify($cartItem, $quoteItem->getQuantity());
        }

        $this->orderProcessor->process($cart);
    }
}
