<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Context;

use Dedi\SyliusQuotePlugin\Exception\QuoteNotFoundException;
use Dedi\SyliusQuotePlugin\Specification\Quote\IsCartSpecificationInterface;
use Dedi\SyliusQuotePlugin\Storage\QuoteCartStorageInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Channel\Context\ChannelNotFoundException;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Order\Model\OrderInterface;

class SessionAndChannelBasedQuoteCartContext implements QuoteCartContextInterface
{
    public function __construct(
        private readonly ChannelContextInterface $channelContext,
        private readonly QuoteCartStorageInterface $quoteStorage,
        private readonly IsCartSpecificationInterface $isCartSpecification,
    ) {
    }

    public function getCart(): OrderInterface
    {
        try {
            /** @var ChannelInterface $channel */
            $channel = $this->channelContext->getChannel();
        } catch (ChannelNotFoundException $exception) {
            throw new QuoteNotFoundException(null, $exception);
        }

        if (!$this->quoteStorage->hasForChannel($channel)) {
            throw new QuoteNotFoundException('Sylius was not able to find the quote in session');
        }

        $quote = $this->quoteStorage->getForChannel($channel);
        if (null === $quote || !$this->isCartSpecification->isSatisfiedBy($quote)) {
            $this->quoteStorage->removeForChannel($channel);

            throw new QuoteNotFoundException('Sylius was not able to find the quote in session');
        }

        return $quote;
    }
}
