<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Context;

use Dedi\SyliusQuotePlugin\Exception\QuoteNotFoundException;
use Psr\Log\LoggerInterface;
use Sylius\Component\Order\Model\OrderInterface;

class CompositeQuoteCartContext implements QuoteCartContextInterface
{
    private readonly iterable $prioritizedContexts;

    private readonly LoggerInterface $logger;

    public function __construct(
        iterable $prioritizedContexts,
        LoggerInterface $logger,
    ) {
        $this->prioritizedContexts = $prioritizedContexts;
        $this->logger = $logger;
    }

    public function getCart(): OrderInterface
    {
        /** @var QuoteCartContextInterface $quoteContext */
        foreach ($this->prioritizedContexts as $quoteContext) {
            try {
                return $quoteContext->getCart();
            } catch (QuoteNotFoundException $exception) {
                $this->logger->info($exception->getMessage());
            }
        }

        throw new QuoteNotFoundException();
    }
}
