<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Twig;

use Dedi\SyliusQuotePlugin\Specification\OrderItem\IsQuoteItemAndAcceptedSpecificationInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class QuoteExtension extends AbstractExtension
{
    public function __construct(private readonly IsQuoteItemAndAcceptedSpecificationInterface $isOrderItemFromQuote)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_sylius_quote_item_is_from_quote', $this->isOrderItemFromQuote),
        ];
    }
}
