<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\OrderItem;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Dedi\SyliusQuotePlugin\Specification\Quote\IsAcceptedSpecificationInterface;
use InvalidArgumentException;

class IsFromQuoteAndAcceptedSpecification implements IsFromQuoteAndAcceptedSpecificationInterface
{
    public function __construct(
        private readonly IsFromQuoteSpecificationInterface $isFromQuoteSpecification,
        private readonly IsAcceptedSpecificationInterface $isAcceptedSpecification,
    ) {
    }

    public function isSatisfiedBy(OrderItemInterface $orderItem): bool
    {
        if (!$this->isFromQuoteSpecification->isSatisfiedBy($orderItem)) {
            return false;
        }

        $order = $orderItem->getOrder();

        if (!$order instanceof OrderInterface) {
            throw new InvalidArgumentException(sprintf(
                'Expected an instance of "%s", got "%s"',
                OrderInterface::class,
                get_class($order),
            ));
        }

        return $this->isAcceptedSpecification->isSatisfiedBy($order);
    }
}
