<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use DateTime;
use Dedi\SyliusQuotePlugin\Entity\OrderInterface;

class QuoteExpirationDateSetter implements QuoteExpirationDateSetterInterface
{
    public function setExpirationDate(OrderInterface $quote): void
    {
        $expirationDate = new DateTime();
        $expirationDate->modify('+3 months');

        $quoteInformation = $quote->getQuoteInformation();

        if (null === $quoteInformation) {
            return;
        }

        $quoteInformation->setExpirationDate($expirationDate);
    }
}
