export default class QuoteItemPriceFetch {
    constructor({
        channelCode,
        channelPricingFetchUrl
    }) {
        document.addEventListener('change', function (element) {
            if (element.target && element.target.className === 'autocomplete') {
                const variantId = element.target.value;
                const priceInput = element.target.closest('[data-form-collection="item"]').querySelector('input.item-unit-price');
                const inputContainerDiv = priceInput.closest('div.input');

                inputContainerDiv.classList.add('disabled');

                const searchParams = new URLSearchParams();
                searchParams.append('channelCode', channelCode);
                searchParams.append('variantId', variantId);

                fetch(channelPricingFetchUrl + '?' + searchParams.toString(), { method: 'GET' })
                    .then(response => response.json())
                    .then((channelPricing) => {
                        priceInput.value = channelPricing.price;

                        const event = new Event('input', { bubbles: true });
                        priceInput.dispatchEvent(event);

                        inputContainerDiv.classList.remove('disabled');
                    });
            }
        });
    }
}
