<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Processor\Quote;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;

class QuoteAdjustmentsClearer implements QuoteProcessorInterface
{
    private array $adjustmentsToRemove;

    public function __construct(array $adjustmentsToRemove = [])
    {
        $this->adjustmentsToRemove = $adjustmentsToRemove;
    }

    public function process(OrderInterface $quote): void
    {
        foreach ($this->adjustmentsToRemove as $type) {
            $quote->removeAdjustmentsRecursively($type);
        }
    }
}
