<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Processor\Quote;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Laminas\Stdlib\PriorityQueue;

class CompositeQuoteProcessor implements QuoteProcessorInterface
{
    /**
     * @var PriorityQueue|QuoteProcessorInterface[]
     * @psalm-var PriorityQueue<QuoteProcessorInterface>
     */
    private readonly PriorityQueue $quoteProcessors;

    public function __construct()
    {
        $this->quoteProcessors = new PriorityQueue();
    }

    public function addProcessor(QuoteProcessorInterface $quoteProcessor, int $priority = 0): void
    {
        $this->quoteProcessors->insert($quoteProcessor, $priority);
    }

    public function process(OrderInterface $quote): void
    {
        /** @var QuoteProcessorInterface $quoteProcessor */
        foreach ($this->quoteProcessors as $quoteProcessor) {
            $quoteProcessor->process($quote);
        }
    }
}
