<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\NumberGenerator;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;

class IdBasedQuoteNumberGenerator implements QuoteNumberGeneratorInterface
{
    private readonly int $startNumber;

    private readonly int $padLength;

    private readonly string $padString;

    public function __construct(int $startNumber, int $padLength, string $padString)
    {
        $this->startNumber = $startNumber;
        $this->padLength = $padLength;
        $this->padString = $padString;
    }

    public function generate(OrderInterface $quote): string
    {
        $number = $this->startNumber + $quote->getQuoteInformation()->getId();

        return str_pad((string) $number, $this->padLength, $this->padString, \STR_PAD_LEFT);
    }
}
