<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Factory;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\QuoteInformation;
use Dedi\SyliusQuotePlugin\Enum\QuoteTransitionEnum;
use SM\Factory\FactoryInterface as StateMachineFactoryInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;

class QuoteFactory implements QuoteFactoryInterface
{
    private FactoryInterface $orderFactory;

    private StateMachineFactoryInterface $stateMachineFactory;

    public function __construct(
        FactoryInterface $orderFactory,
        StateMachineFactoryInterface $stateMachineFactory,
    ) {
        $this->orderFactory = $orderFactory;
        $this->stateMachineFactory = $stateMachineFactory;
    }

    public function createNew(): OrderInterface
    {
        $quote = $this->orderFactory->createNew();

        if (!$quote instanceof OrderInterface) {
            throw new \InvalidArgumentException('The order factory must create an instance of OrderInterface');
        }

        $quoteInformation = new QuoteInformation();
        $quote->setQuoteInformation($quoteInformation);

        $stateMachine = $this->stateMachineFactory->get($quote, QuoteTransitionEnum::GRAPH);
        $stateMachine->apply(QuoteTransitionEnum::TRANSITIONS_CART);

        return $quote;
    }
}
