<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Sales;

use Dedi\SyliusQuotePlugin\Context\QuoteCartContextInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Sylius\Bundle\CoreBundle\SectionResolver\SectionProviderInterface;
use Sylius\Bundle\ShopBundle\SectionResolver\ShopSection;
use Sylius\Bundle\UserBundle\Event\UserEvent;
use Sylius\Component\Core\Model\ShopUserInterface;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;

class ShopQuoteBlamerListener
{
    private readonly SectionProviderInterface $uriBasedSectionContext;

    private readonly QuoteCartContextInterface $quoteContext;

    public function __construct(SectionProviderInterface $uriBasedSectionContext, QuoteCartContextInterface $quoteContext)
    {
        $this->uriBasedSectionContext = $uriBasedSectionContext;
        $this->quoteContext = $quoteContext;
    }

    public function onImplicitLogin(UserEvent $userEvent): void
    {
        if (!$this->uriBasedSectionContext->getSection() instanceof ShopSection) {
            return;
        }

        $user = $userEvent->getUser();
        if (!$user instanceof ShopUserInterface) {
            return;
        }

        $this->blame($user);
    }

    public function onInteractiveLogin(InteractiveLoginEvent $interactiveLoginEvent): void
    {
        $section = $this->uriBasedSectionContext->getSection();
        if (!$section instanceof ShopSection) {
            return;
        }

        $user = $interactiveLoginEvent->getAuthenticationToken()->getUser();
        if (!$user instanceof ShopUserInterface) {
            return;
        }

        $this->blame($user);
    }

    private function blame(ShopUserInterface $shopUser): void
    {
        /** @var OrderInterface $quote */
        $quote = $this->quoteContext->getCart();
        if (null !== $quote->getCustomer()) {
            return;
        }

        $quote->setCustomer($shopUser->getCustomer());
    }
}
