<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Menu;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class AdminMenuListener
{
    public function __construct(
        private readonly SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function __invoke(MenuBuilderEvent $event)
    {
        if (!$this->settingsProvider->provide()->isEnabled()) {
            return;
        }

        $menu = $event->getMenu();

        $salesNode = $menu->getChild('sales');
        if (null !== $salesNode) {
            $salesNode
                ->addChild('dedi_sylius_quote_quotes', ['route' => 'dedi_sylius_quote_admin_quote_information_index'])
                ->setLabel('dedi_sylius_quote.ui.quote.menu_entry')
                ->setLabelAttribute('icon', 'handshake')
            ;
        }
    }
}
