<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Entity;

use Doctrine\Common\Collections\Collection;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\TimestampableInterface;

interface QuoteInformationInterface extends ResourceInterface, TimestampableInterface
{
    public function getExpirationDate(): ?\DateTimeInterface;

    public function setExpirationDate(?\DateTimeInterface $expirationDate): self;

    public function setOrder(OrderInterface $order): self;

    public function getOrder(): OrderInterface;

    public function getTotal(): ?int;

    public function setTotal(?int $total): self;

    public function getItemsTotal(): ?int;

    public function getNumber(): ?string;

    public function setNumber(?string $number): self;

    public function getCustomerComment(): ?string;

    public function setCustomerComment(?string $customerComment): self;

    public function getInformationComment(): ?string;

    public function setInformationComment(?string $informationComment): self;

    public function getInternalComments(): Collection;

    public function setInternalComments(Collection $internalComments): self;

    public function hasInternalComment(InternalCommentInterface $internalComment): bool;

    public function addInternalComment(InternalCommentInterface $internalComment): self;

    public function removeInternalComment(InternalCommentInterface $internalComment): self;
}
