<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\DependencyInjection\Settings\Twig;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusQuotePlugin\DependencyInjection\Settings\SettingsInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Webmozart\Assert\Assert;

class SettingsCheckerExtension extends AbstractExtension
{
    public function __construct(private readonly SettingsProviderInterface $settingsProvider)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_sylius_quote_check', [$this, 'check']),
            new TwigFunction('dedi_sylius_quote_is_enabled', [$this, 'isEnabled']),
        ];
    }

    public function check(string $setting): mixed
    {
        $settings = $this->settingsProvider->provide();

        Assert::isInstanceOf($settings, SettingsInterface::class);

        switch ($setting) {
            case 'enabled':
                return $settings->isEnabled();
            case 'anonymous_quote_allowed':
                return $settings->isAnonymousQuoteAllowed();
            case 'cart_edit_allowed':
                return $settings->isCartEditAllowed();
            default:
                throw new \InvalidArgumentException(sprintf('Unrecognized Quote Plugin setting %s', $setting));
        }
    }

    public function isEnabled(): bool
    {
        return (bool) $this->check('enabled');
    }
}
