<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\DependencyInjection\Settings;

class Settings implements SettingsInterface
{
    public function __construct(
        private readonly bool $enabled,
        private readonly bool $anonymousQuoteAllowed,
        private readonly bool $cartEditAllowed,
    ) {
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function isAnonymousQuoteAllowed(): bool
    {
        return $this->anonymousQuoteAllowed;
    }

    public function isCartEditAllowed(): bool
    {
        return $this->cartEditAllowed;
    }
}
