<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\DependencyInjection;

use Dedi\SyliusQuotePlugin\Processor\Quote\QuoteProcessorInterface;
use Sylius\Bundle\ResourceBundle\DependencyInjection\Compiler\PrioritizedCompositeServicePass;
use Symfony\Component\DependencyInjection\ContainerBuilder;

final class RegisterProcessorsPass extends PrioritizedCompositeServicePass
{
    public const PROCESSOR_SERVICE_TAG = 'dedi_sylius_quote.quote_processor';

    public function __construct()
    {
        parent::__construct(
            'dedi_sylius_quote.quote_processing.quote_processor',
            'dedi_sylius_quote.quote_processing.quote_processor.composite',
            self::PROCESSOR_SERVICE_TAG,
            'addProcessor',
        );
    }

    public function process(ContainerBuilder $container): void
    {
        parent::process($container);

        $container->setAlias(QuoteProcessorInterface::class, 'dedi_sylius_quote.quote_processing.quote_processor');
    }
}
