<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Converter;

use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;

class OrderItemHydrator implements OrderItemHydratorInterface
{
    public function hydrateFromQuoteItem(OrderItemInterface $orderItem, OrderItemInterface $quoteItem): void
    {
        $orderItem->setVariant($quoteItem->getVariant());
        $orderItem->setProductName($quoteItem->getProductName());
        $orderItem->setVariantName($quoteItem->getVariantName());
        $orderItem->setQuoteItem($quoteItem);
        $orderItem->setUnitPrice($quoteItem->getQuoteItemInformation()->getUnitPrice());
        $orderItem->setOriginalUnitPrice($quoteItem->getOriginalUnitPrice());
        $orderItem->setImmutable(true);
    }
}
