<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Context;

use Dedi\SyliusQuotePlugin\Exception\QuoteNotFoundException;
use Dedi\SyliusQuotePlugin\Repository\QuoteRepositoryInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Channel\Context\ChannelNotFoundException;
use Sylius\Component\Customer\Context\CustomerContextInterface;
use Sylius\Component\Order\Model\OrderInterface;

class CustomerAndChannelBasedQuoteCartContext implements QuoteCartContextInterface
{
    private readonly ChannelContextInterface $channelContext;

    private readonly CustomerContextInterface $customerContext;

    private readonly QuoteRepositoryInterface $quoteRepository;

    public function __construct(
        ChannelContextInterface $channelContext,
        CustomerContextInterface $customerContext,
        QuoteRepositoryInterface $quoteRepository,
    ) {
        $this->channelContext = $channelContext;
        $this->customerContext = $customerContext;
        $this->quoteRepository = $quoteRepository;
    }

    public function getCart(): OrderInterface
    {
        try {
            $channel = $this->channelContext->getChannel();
        } catch (ChannelNotFoundException $exception) {
            throw new QuoteNotFoundException('Sylius was not able to find the quote, as there is no current channel.');
        }

        $customer = $this->customerContext->getCustomer();
        if (null === $customer) {
            throw new QuoteNotFoundException('Sylius was not able to find the quote, as there is no logged in user.');
        }

        $quote = $this->quoteRepository->findLatestNotEmptyQuoteCartByChannelAndCustomer($channel, $customer);
        if (null === $quote) {
            throw new QuoteNotFoundException('Sylius was not able to find the quote for currently logged in user.');
        }

        return $quote;
    }
}
