<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Twig\FormComponent;

use Dedi\SyliusQuotePlugin\Context\QuoteCartContextInterface;
use Sylius\Bundle\UiBundle\Twig\Component\ResourceLivePropTrait;
use Sylius\Bundle\UiBundle\Twig\Component\TemplatePropTrait;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Repository\OrderRepositoryInterface;
use Sylius\Component\Order\Context\CartNotFoundException;
use Sylius\Resource\Model\ResourceInterface;
use Sylius\TwigHooks\LiveComponent\HookableLiveComponentTrait;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\Attribute\LiveListener;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\TwigComponent\Attribute\PreMount;

#[AsLiveComponent]
class QuoteWidgetComponent
{
    use DefaultActionTrait;
    use HookableLiveComponentTrait;
    use TemplatePropTrait;

    /** @use ResourceLivePropTrait<OrderInterface> */
    use ResourceLivePropTrait;

    #[LiveProp(hydrateWith: 'hydrateResource', dehydrateWith: 'dehydrateResource')]
    public ?ResourceInterface $cart = null;

    /** @param OrderRepositoryInterface<OrderInterface> $orderRepository */
    public function __construct(
        protected readonly QuoteCartContextInterface $quoteCartContext,
        OrderRepositoryInterface $orderRepository,
    ) {
        $this->initialize($orderRepository);
    }

    #[PreMount]
    public function initializeQuote(): void
    {
        $this->cart = $this->getQuote();
    }

    #[LiveListener(QuoteFormComponent::SYLIUS_SHOP_QUOTE_CHANGED)]
    #[LiveListener(QuoteFormComponent::SYLIUS_SHOP_QUOTE_CLEARED)]
    public function refreshCart(#[LiveArg] mixed $cartId = null): void
    {
        if ($cartId === null) {
            $this->cart = $this->getQuote();

            return;
        }

        $this->cart = $this->hydrateResource($cartId);
    }

    private function getQuote(): ?OrderInterface
    {
        try {
            /** @var OrderInterface $quote */
            $quote = $this->quoteCartContext->getCart();
        } catch (CartNotFoundException) {
            return null;
        }

        return $quote;
    }
}
