<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Specification\Order;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteInformationStateEnum;

class IsQuoteSpecification implements IsQuoteSpecificationInterface
{
    public function isSatisfiedBy(OrderInterface $order): bool
    {
        return $order->getQuoteState() !== QuoteInformationStateEnum::STATE_NONE;
    }
}
