<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteTransitionEnum;
use Dedi\SyliusQuotePlugin\Specification\Order\IsQuoteSpecificationInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Workflow\WorkflowInterface;

class QuoteValidatedStateApplicator implements QuoteValidatedStateApplicatorInterface
{
    public function __construct(
        private readonly WorkflowInterface $workflow,
        private readonly EntityManagerInterface $entityManager,
        private readonly IsQuoteSpecificationInterface $isQuoteSpecification,
    ) {
    }

    public function apply(OrderInterface $order): void
    {
        if (!$this->isQuoteSpecification->isSatisfiedBy($order)) {
            return;
        }

        $this->workflow->apply($order, QuoteTransitionEnum::TRANSITIONS_VALIDATE);

        $this->entityManager->persist($order);
    }
}
