<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
use Doctrine\ORM\EntityManagerInterface;

class QuoteItemLocker implements QuoteItemLockerInterface
{
    private EntityManagerInterface $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    public function lockItems(OrderInterface $order): void
    {
        /** @var OrderItemInterface $item */
        foreach ($order->getItems() as $item) {
            $item->setImmutable(true);
            $this->entityManager->persist($item);
        }
        $this->entityManager->flush();
    }
}
