<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class QuoteIdSessionManager implements QuoteIdSessionManagerInterface
{
    private readonly string $sessionKeyName;

    private readonly RequestStack $requestStack;

    public function __construct(string $sessionKeyName, RequestStack $requestStack)
    {
        $this->sessionKeyName = $sessionKeyName;
        $this->requestStack = $requestStack;
    }

    public function getQuoteIdFromSession(): ?int
    {
        $session = $this->requestStack->getSession();

        return $session->get($this->sessionKeyName);
    }

    public function setQuoteIdInSession(OrderInterface $quote): void
    {
        $session = $this->requestStack->getSession();
        $session->set($this->sessionKeyName, $quote->getId());
    }

    public function removeQuoteIdInSession(): void
    {
        $session = $this->requestStack->getSession();
        if ($session->has($this->sessionKeyName)) {
            $session->remove($this->sessionKeyName);
        }
    }
}
