<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Service;

use DateTimeInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Enum\QuoteTransitionEnum;
use Dedi\SyliusQuotePlugin\Repository\QuoteRepositoryInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Workflow\WorkflowInterface;

class ExpiredQuoteRemover implements ExpiredQuoteRemoverInterface
{
    public function __construct(
        private readonly QuoteRepositoryInterface $quoteRepository,
        private readonly EntityManagerInterface $entityManager,
        private readonly WorkflowInterface $workflow,
        private readonly int $batchSize,
    ) {
    }

    /**
     * @inheritdoc
     */
    public function deleteExpiredQuotes(DateTimeInterface $dateTime): void
    {
        $count = 0;
        $expiredQuotes = $this->quoteRepository->findExpiredQuotes($dateTime);

        /** @var OrderInterface $expiredQuote */
        foreach ($expiredQuotes as $expiredQuote) {
            $this->workflow->apply($expiredQuote, QuoteTransitionEnum::TRANSITIONS_EXPIRE);

            $this->entityManager->persist($expiredQuote);

            if ((++$count % $this->batchSize) === 0) {
                $this->entityManager->flush();
                $this->entityManager->clear();
            }
        }

        $this->entityManager->flush();
    }
}
