export default class QuoteItemPriceFetch {
    constructor({
        channelCode,
        channelPricingFetchUrl
    }) {
        document.addEventListener('change', function (element) {
            if (element.target && element.target.className.indexOf('autocomplete') !== -1) {
                const variant = element.target.value;
                const priceInput = element.target.closest('.item').querySelector('input.item-unit-price');
                const inputContainerDiv = priceInput.closest('div.input-group');

                inputContainerDiv.classList.add('disabled');

                const searchParams = new URLSearchParams();
                searchParams.append('channelCode', channelCode);
                searchParams.append('variant', variant);

                fetch(channelPricingFetchUrl + '?' + searchParams.toString(), { method: 'GET' })
                    .then(response => response.json())
                    .then((channelPricing) => {
                        priceInput.value = channelPricing.price;

                        const event = new Event('input', { bubbles: true });
                        priceInput.dispatchEvent(event);

                        inputContainerDiv.classList.remove('disabled');
                    });
            }
        });
    }
}
