<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Repository;

use Dedi\SyliusQuotePlugin\Enum\QuoteInformationStateEnum;
use Doctrine\ORM\QueryBuilder;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;

class QuoteInformationRepository extends EntityRepository implements QuoteInformationRepositoryInterface
{
    public function createListQueryBuilder(): QueryBuilder
    {
        return $this->createQueryBuilder('qi')
            ->addSelect('c')
            ->addSelect('o')
            ->leftJoin('qi.order', 'o')
            ->leftJoin('o.customer', 'c')
            ->andWhere('o.quoteState NOT IN(:states)')
            ->setParameter('states', [QuoteInformationStateEnum::STATE_CART, QuoteInformationStateEnum::STATE_NONE])
        ;
    }

    public function createByCustomerAndChannelIdQueryBuilder($customerId, $channelId): QueryBuilder
    {
        return $this->createQueryBuilder('qi')
            ->innerJoin('qi.order', 'o')
            ->andWhere('o.customer = :customerId')
            ->andWhere('o.channel = :channelId')
            ->andWhere('o.quoteState != :state')
            ->setParameter('customerId', $customerId)
            ->setParameter('channelId', $channelId)
            ->setParameter('state', QuoteInformationStateEnum::STATE_CART)
        ;
    }
}
