<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Generator;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Model\QuotePdf;

/**
 * Decorate this service to create your own logic to render a PDF file
 */
class QuotePdfFileGenerator implements QuotePdfFileGeneratorInterface
{
    public function generate(OrderInterface $quote): QuotePdf
    {
        return new QuotePdf(sprintf('%s.pdf', $quote->getNumber()), '');
    }
}
