<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Form\Type;

use Dedi\SyliusQuotePlugin\Entity\InternalCommentInterface;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Validator\Constraints\NotBlank;

class QuoteInternalCommentType extends AbstractResourceType
{
    public function __construct(
        string $dataClass,
        array $validationGroups,
        private readonly Security $security,
    ) {
        parent::__construct($dataClass, $validationGroups);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            /** @var InternalCommentInterface|null $data */
            $data = $event->getData();

            if (null === $data || $data->getUser() === $this->security->getUser()) {
                $formType = TextareaType::class;
            } else {
                $formType = HiddenType::class;
            }

            $event
                ->getForm()
                ->add('comment', $formType, [
                    'label' => false,
                    'required' => true,
                    'constraints' => [
                        new NotBlank(),
                    ],
                ])
            ;
        });
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_sylius_quote_internal_comment';
    }
}
