<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Form\Type;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

class OrderType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('items', LiveCollectionType::class, [
                'label' => false,
                'entry_type' => OrderItemType::class,
                'entry_options' => [
                    'label' => false,
                    'currency' => $options['data']->getCurrencyCode(),
                    'quote' => $options['data'],
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'delete_empty' => true,
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => OrderInterface::class,
        ]);
    }
}
