<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Form\Type\Admin;

use Dedi\SyliusQuotePlugin\Entity\InternalCommentInterface;
use Dedi\SyliusQuotePlugin\Entity\QuoteInformationInterface;
use Dedi\SyliusQuotePlugin\Form\Type\OrderType;
use Dedi\SyliusQuotePlugin\Form\Type\QuoteInternalCommentType;
use Sylius\Bundle\MoneyBundle\Form\Type\MoneyType;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Component\Core\Model\AdminUserInterface;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;

class QuoteInformationType extends AbstractResourceType
{
    public function __construct(
        private readonly Security $security,
        string $dataClass,
        array $validationGroups = [],
    ) {
        parent::__construct($dataClass, $validationGroups);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $order = $options['data']->getOrder();
        $builder
            ->add('expirationDate', DateType::class, [
                'widget' => 'single_text',
                'html5' => true,
            ])
            ->add('informationComment', TextareaType::class)
            ->add('internalComments', LiveCollectionType::class, [
                'label' => false,
                'entry_type' => QuoteInternalCommentType::class,
                'entry_options' => ['label' => false],
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
            ])
            ->add('order', OrderType::class, [
                'data' => $order,
            ])
            ->add('total', MoneyType::class, [
                'label' => false,
                'currency' => $order->getCurrencyCode(),
                'constraints' => [
                    new NotBlank(['groups' => $this->validationGroups]),
                ],
            ])
        ;

        $builder->addEventListener(FormEvents::SUBMIT, $this->setInternalCommentsAdminUser(...));
    }

    public function setInternalCommentsAdminUser(FormEvent $event): void
    {
        /** @var QuoteInformationInterface $quoteInformation */
        $quoteInformation = $event->getData();

        $currentUser = $this->security->getUser();
        if (!$currentUser instanceof AdminUserInterface) {
            return;
        }

        /** @var InternalCommentInterface $internalComment */
        foreach ($quoteInformation->getInternalComments() as $internalComment) {
            if (null === $internalComment->getId()) {
                $internalComment->setUser($currentUser);
            }
        }
    }
}
