<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Factory;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Entity\QuoteInformation;
use Dedi\SyliusQuotePlugin\Enum\QuoteTransitionEnum;
use Sylius\Component\Resource\Factory\FactoryInterface;
use Symfony\Component\Workflow\WorkflowInterface;

class QuoteFactory implements QuoteFactoryInterface
{
    public function __construct(
        private readonly FactoryInterface $orderFactory,
        private readonly WorkflowInterface $workflow,
    ) {
    }

    public function createNew(): OrderInterface
    {
        $quote = $this->orderFactory->createNew();

        if (!$quote instanceof OrderInterface) {
            throw new \InvalidArgumentException('The order factory must create an instance of OrderInterface');
        }

        $quoteInformation = new QuoteInformation();
        $quote->setQuoteInformation($quoteInformation);

        $this->workflow->apply($quote, QuoteTransitionEnum::TRANSITIONS_CART);

        return $quote;
    }
}
