<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Sales;

use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Storage\QuoteCartStorageInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Order\Context\CartContextInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;

class SessionQuoteEventListener
{
    private readonly CartContextInterface $quoteContext;

    private readonly QuoteCartStorageInterface $quoteStorage;

    public function __construct(CartContextInterface $quoteCartContext, QuoteCartStorageInterface $quoteCartStorage)
    {
        $this->quoteContext = $quoteCartContext;
        $this->quoteStorage = $quoteCartStorage;
    }

    public function __invoke(ResponseEvent $event)
    {
        if (!$event->isMainRequest()) {
            return;
        }

        $request = $event->getRequest();

        if (!$request->hasSession() || !$request->getSession()->isStarted()) {
            return;
        }

        /** @var OrderInterface $quote */
        $quote = $this->quoteContext->getCart();

        /** @var ?ChannelInterface $channel */
        $channel = $quote->getChannel();
        if (null !== $channel && null !== $quote->getId()) {
            $this->quoteStorage->setForChannel($channel, $quote);
        }
    }
}
