<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Sales;

use Dedi\SyliusQuotePlugin\Entity\QuoteInformationInterface;
use Dedi\SyliusQuotePlugin\Processor\Quote\QuoteProcessorInterface;
use Symfony\Component\EventDispatcher\GenericEvent;

class QuoteAdminListener
{
    private QuoteProcessorInterface $quoteProcessor;

    public function __construct(
        QuoteProcessorInterface $quoteProcessor,
    ) {
        $this->quoteProcessor = $quoteProcessor;
    }

    public function __invoke(GenericEvent $event): void
    {
        $quoteInformation = $event->getSubject();

        if (!$quoteInformation instanceof QuoteInformationInterface) {
            return;
        }

        $this->quoteProcessor->process($quoteInformation->getOrder());
    }
}
