<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Sales;

use Dedi\SyliusQuotePlugin\DependencyInjection\Settings\SettingsInterface;
use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
use Dedi\SyliusQuotePlugin\Service\QuoteConfigurationAwareInterface;
use Dedi\SyliusQuotePlugin\Specification\Order\IsFromQuoteSpecificationInterface;
use InvalidArgumentException;
use Sylius\Bundle\ResourceBundle\Event\ResourceControllerEvent;

class OrderQuoteLockListener implements QuoteConfigurationAwareInterface
{
    public function __construct(
        private readonly SettingsInterface $quoteConfiguration,
        private readonly IsFromQuoteSpecificationInterface $isFromQuoteSpecification,
    ) {
    }

    public function __invoke(ResourceControllerEvent $event): void
    {
        if ($this->quoteConfiguration->isCartEditAllowed()) {
            return;
        }

        $order = $event->getSubject();

        if (!$order instanceof OrderInterface) {
            throw new InvalidArgumentException(sprintf(
                'Expected an instance of "%s", got "%s"',
                OrderInterface::class,
                get_class($order),
            ));
        }

        if ($this->isFromQuoteSpecification->isSatisfiedBy($order)) {
            $event->stop('dedi_sylius_quote.cart.cannot_update_from_quote');
        }
    }

    public function getQuoteConfiguration(): SettingsInterface
    {
        return $this->quoteConfiguration;
    }
}
