<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\EventListener\Menu;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

class AccountMenuListener
{
    public function __construct(
        private readonly SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function __invoke(MenuBuilderEvent $event): void
    {
        if (!$this->settingsProvider->provide()->isEnabled()) {
            return;
        }

        $menu = $event->getMenu();
        $menu
            ->addChild('quotes', ['route' => 'dedi_sylius_quote_shop_account_quote_index'])
            ->setLabel('dedi_sylius_quote.ui.quotes')
            ->setLabelAttribute('icon', 'material-symbols-light:handshake-outline')
        ;
    }
}
