<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

trait QuoteOrderItemTrait
{
    #[ORM\ManyToOne(targetEntity: "Sylius\Component\Order\Model\OrderItemInterface", inversedBy: 'orderItems')]
    #[ORM\JoinColumn(name: 'quote_item_id', referencedColumnName: 'id', nullable: true)]
    private ?OrderItemInterface $quoteItem = null;

    #[ORM\OneToMany(mappedBy: 'quoteItem', targetEntity: "Sylius\Component\Order\Model\OrderItemInterface")]
    private Collection $orderItems;

    #[ORM\OneToOne(mappedBy: 'orderItem', targetEntity: "Dedi\SyliusQuotePlugin\Entity\QuoteItemInformationInterface", cascade: ['all'], orphanRemoval: true)]
    protected ?QuoteItemInformationInterface $quoteItemInformation = null;

    public function initializeQuoteOrderItems(): void
    {
        $this->orderItems = new ArrayCollection();
    }

    public function getQuoteItemInformation(): ?QuoteItemInformationInterface
    {
        return $this->quoteItemInformation;
    }

    public function setQuoteItemInformation(?QuoteItemInformationInterface $quoteItemInformation = null): self
    {
        $quoteItemInformation->setOrderItem($this);
        $this->quoteItemInformation = $quoteItemInformation;

        return $this;
    }

    public function setQuantity(int $quantity): self
    {
        $this->quantity = $quantity;

        return $this;
    }

    public function getQuoteItem(): ?OrderItemInterface
    {
        return $this->quoteItem;
    }

    public function setQuoteItem(?OrderItemInterface $quoteItem): self
    {
        $this->quoteItem = $quoteItem;

        return $this;
    }

    public function getOrderItems(): Collection
    {
        return $this->orderItems;
    }

    public function hasOrderItem(OrderItemInterface $orderItem): bool
    {
        return $this->orderItems->contains($orderItem);
    }

    public function addOrderItem(OrderItemInterface $orderItem): self
    {
        if (!$this->hasOrderItem($orderItem)) {
            $this->orderItems->add($orderItem);
            $orderItem->setQuoteItem($this);
        }

        return $this;
    }

    public function removeOrderItem(OrderItemInterface $orderItem): self
    {
        if ($this->hasOrderItem($orderItem)) {
            $this->orderItems->removeElement($orderItem);
            $orderItem->setQuoteItem(null);
        }

        return $this;
    }
}
