<?php

declare(strict_types=1);

namespace Dedi\SyliusQuotePlugin\Controller;

use Dedi\SyliusQuotePlugin\DependencyInjection\Settings\SettingsInterface;
use Dedi\SyliusQuotePlugin\Service\QuoteConfigurationAwareInterface;
use Sylius\Bundle\ResourceBundle\Controller\AuthorizationCheckerInterface;
use Sylius\Bundle\ResourceBundle\Controller\RequestConfiguration;
use Sylius\Component\Core\Model\AdminUserInterface;
use Sylius\Component\Customer\Context\CustomerContextInterface;
use Symfony\Bundle\SecurityBundle\Security;

class QuoteAuthorizationChecker implements AuthorizationCheckerInterface, QuoteConfigurationAwareInterface
{
    private readonly SettingsInterface $quoteConfiguration;

    private readonly Security $security;

    private readonly AuthorizationCheckerInterface $decoratedAuthorizationChecker;

    private readonly CustomerContextInterface $customerContext;

    public function __construct(
        SettingsInterface $quoteConfiguration,
        Security $security,
        AuthorizationCheckerInterface $decoratedAuthorizationChecker,
        CustomerContextInterface $customerContext,
    ) {
        $this->quoteConfiguration = $quoteConfiguration;
        $this->security = $security;
        $this->decoratedAuthorizationChecker = $decoratedAuthorizationChecker;
        $this->customerContext = $customerContext;
    }

    public function isGranted(RequestConfiguration $configuration, string $permission): bool
    {
        if ($this->getQuoteConfiguration()->isAnonymousQuoteAllowed()) {
            return true;
        }

        if ($this->security->getUser() instanceof AdminUserInterface) {
            return true;
        }

        if ('dedi_sylius_quote.quote.update' === $permission) {
            return $this->customerIsGranted();
        }

        return $this->decoratedAuthorizationChecker->isGranted($configuration, $permission);
    }

    private function customerIsGranted(): bool
    {
        return null !== $this->customerContext->getCustomer();
    }

    public function getQuoteConfiguration(): SettingsInterface
    {
        return $this->quoteConfiguration;
    }
}
