## Authorization

### Anonymous Quote

By default, the plugin does **not** allow for anonymous quote (aka create a quote without being connected).
This can be changed by setting the `anonymous_quote_allowed` parameter in the configuration to `true`.

If set to `false`, this parameter enables the `QuoteAuthorizationChecker` (which decorates the basic `AuthorizationChecker` of sylius : `DisabledAuthorizationChecker`).

This service will check the user's permission for the following actions :

- Update (permission `dedi_sylius_quote.quote.update`)
- PDF Download (permission `dedi_sylius_quote.quote.download`)

:warning: These check will only be done only if :

- The route has the `permission` parameter set to `true`, for instance :
```yaml
dedi_sylius_quote_shop_quote_confirmation:
    path: /confirmation
    methods: [ GET ]
    defaults:
        _controller: sylius.controller.order:confirmationAction
        _sylius:
            permission: true
            template: "@DediSyliusQuotePlugin/shop/quote/confirmation.html.twig"
```

- The method `$this->isGrantedOr403(...);` is called inside your Controller (which must extend Sylius' ResourceController), for instance :
```php
    public function downloadPdfAction(
        Request $request,
        string $number,
        QuotePdfFileGeneratorInterface $quotePdfFileGenerator
    ): Response {
        $configuration = $this->requestConfigurationFactory->create($this->metadata, $request);

        $this->isGrantedOr403($configuration, QuoteActionEnum::DOWNLOAD);

        // ...
    }
```

### CartItem modification

When converting a quote into a cart, you can decide to allow or block the modification of the cart items (for instance, to prevent a quantity update that will modify the price).
This behaviour is enabled by default, but you can choose to disable it by setting the `cart_edit_allowed` parameter to true in the configuration.

If set to `false`, this parameter enables the `OrderItemPreDeleteListener` service. This service listens for the `sylius.order_item.pre_remove` event.

If the `OrderItem` the user is trying to delete is from a quote (check done by the `IsOrderItemFromQuoteSpecification` service), then the event will be stopped, and this `OrderItem` won't be deleted.

## Symfony Command

In order to apply the `expired` transition to the expired quotes, you can manually or programmatically launch the following command

```bash
    bin/console dedi:quote:clean-expired
```

You can also specify the expiration date if needed.
This parameter is optional, as it defaults to the current date if not given.

```bash
    bin/console dedi:quote:clean-expired 31-12-2020
```

## PDF Generation

In order to generate a PDF version of a Quote, you need to decorate/re-declare the 
`QuotePdfFileGenerator` service to implement your own way of generating a PDF file.

This service will need to implement the `QuotePdfFileGeneratorInterface`.
